MODEL pqv_3 -- measurement of  (P, Q, S, V) [VA] in 3_phase system

     CONST
        N {VAL: 20}       -- liczba probek w okresie probkowania
        F {VAL: 50}       -- czestotliwosc sieci (Hz)
        V_nom {VAL:525000}

     VAR                  -- deklaracja zmiennych
        hc[1..N]          -- funkcja korelacyjna cos
        hs[1..N]          --                     sin
        kn                -- indeks numeru probki w oknie
        t_next            -- czas nastepnego probkowania [s]
        t_s               -- okres probkowania

        xvta[1..N]         -- przechowywane probki fazowe napiecia
        xvtb[1..N] 
        xvtc[1..N] 
        xita[1..N]         --                             pradu
        xitb[1..N]
        xitc[1..N]
        xpcv[1..3]              -- cos/sin napiecia
        xpsv[1..3]
        xpci[1..3]              -- cos/sin pradu
        xpsi[1..3]
        pP[1..3]
        qQ[1..3]
        q3
        p3
        s3
        V3
        v_3

     INPUT                -- Model inputs
        IN_V[1..3]              -- sygnal wejsciowy napiecia
        IN_I[1..3]              -- sygnal wejsciowy pradu

     HISTORY
        V3 {dflt:V_nom}

     INIT
      -- setting of the impulse function of the correlator
      t_s:=2*pi/N
      FOR j:=1 TO N DO
       hc[j]:=2*cos((j-1)*t_s)/N
       hs[j]:=2*sin((j-1)*t_s)/N
      ENDFOR
      kn:=1
      t_next:=0
      t_s:=1/(N*F)
      xvta[1..N]:=0
      xita[1..N]:=0
      xvtb[1..N]:=0
      xitb[1..N]:=0
      xvtc[1..N]:=0
      xitc[1..N]:=0
      xpcv[1..3]:=0 xpsv[1..3]:=0
      xpci[1..3]:=0 xpsi[1..3]:=0
     ENDINIT

    EXEC       -- pqv_3
  ----- probkowanie -----
     IF abs(t-t_next)<(0.5*timestep) THEN
     -- obliczenie skladowych ortogonalnych
      xpcv[1]:=xpcv[1]+hc[kn]*(IN_V[1]-xvta[N])        -- korelacja napiecia
      xpsv[1]:=xpsv[1]-hs[kn]*(IN_V[1]-xvta[N])
      xpci[1]:=xpci[1]+hc[kn]*(IN_I[1]-xita[N])        -- korelacja pradu
      xpsi[1]:=xpsi[1]-hs[kn]*(IN_I[1]-xita[N])
      xpcv[2]:=xpcv[2]+hc[kn]*(IN_V[2]-xvtb[N])        -- korelacja napiecia
      xpsv[2]:=xpsv[2]-hs[kn]*(IN_V[2]-xvtb[N])
      xpci[2]:=xpci[2]+hc[kn]*(IN_I[2]-xitb[N])        -- korelacja pradu
      xpsi[2]:=xpsi[2]-hs[kn]*(IN_I[2]-xitb[N])
      xpcv[3]:=xpcv[3]+hc[kn]*(IN_V[3]-xvtc[N])        -- korelacja napiecia
      xpsv[3]:=xpsv[3]-hs[kn]*(IN_V[3]-xvtc[N])
      xpci[3]:=xpci[3]+hc[kn]*(IN_I[3]-xitc[N])        -- korelacja pradu
      xpsi[3]:=xpsi[3]-hs[kn]*(IN_I[3]-xitc[N])
      FOR i:=1 TO 3 DO
     -- obliczanie mocy
       pP[i]:=(xpcv[i]*xpci[i]+xpsv[i]*xpsi[i])/2
       qQ[i]:=(xpsv[i]*xpci[i]-xpcv[i]*xpsi[i])/2
      ENDFOR
      FOR j:=N TO 2 BY -1 DO              --memory shifting
        xvta[j]:=xvta[j-1]
        xita[j]:=xita[j-1]
        xvtb[j]:=xvtb[j-1]
        xitb[j]:=xitb[j-1]
        xvtc[j]:=xvtc[j-1]
        xitc[j]:=xitc[j-1]
      ENDFOR
      xvta[1]:=IN_V[1]
      xita[1]:=IN_I[1]
      xvtb[1]:=IN_V[2]
      xitb[1]:=IN_I[2]
      xvtc[1]:=IN_V[3]
      xitc[1]:=IN_I[3]
 
      t_next:=t_next+t_s
      kn:=kn+1
      IF kn>N THEN
       kn:=1
      ENDIF
      p3:=pP[1]+pP[2]+pP[3]
      q3:=qQ[1]+qQ[2]+qQ[3]
      s3:=norm(p3,q3)

     ENDIF
     v_3:=sqrt(IN_V[1]*IN_V[1]+IN_V[2]*IN_V[2]+IN_V[3]*IN_V[3])	-- voltage measurement
     laplace (V3/v_3) := 1| / (1|s0+0.01|s1)			-- filtering
    ENDEXEC
   ENDMODEL -- pqv_3

