MODEL fl_sec -- nonlinear fault model for a secondary arc
	     -- Uwaga: nazwa powinna zawiera nie wicej ni 6 znakw

-- '''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
-- * Model of the Secondary Arc (i.e. after breaker openning) - originaly in TACS        
-- * WUT, Wroclaw, October 2001                                                 
-- * References:                                                             
-- * 1. Goldberg S., Horton W.F., Tziouvaras D.
-- *  "A computer model of the secondary arc in single phase
-- *   operation of transmission line",
-- *   IEEE Trans. on Pawer Delivery, vol. 4 No. 1, January 1989, pp.586-595
-- '''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''

  DATA
      arc_l             -- arc length [cm]
      xip               -- peak value of fault current assuming zero arc resistance
      runtm0            -- secondary arc duration time (during which voltd is constant) [s]
  INPUT 
      ufs               -- voltage drop on arc model
      ifs               -- arc current
      runtim            -- time from the sec. arc initiation (measured here as input current)
  OUTPUT
      swdrv             -- state of the switch model
      voltpl            -- voltage in diode circuit of the sec. arc model
      voltmn
  VAR 
      arczr0		-- indication of zero arc current
      lead
      arcit
      ramrst		-- variable for reset the accumulator
      vamp_0
      dvarc
      varcw		-- arc withstand voltage
      drvfl
      dvarq
      xip0
      ramp              -- time from last current zero
      ramp0
      swdrv		-- switch control (every half cycle)
      voltpl
      voltmn
  HISTORY
   lead {dflt:0.0}

  INIT                  -- initialization at t=0 
   ramp0:=0
   ramp:=0
   xip0:=(2.15+xip/sqrt(2))/1620.0
   vamp_0:=75.0*arc_l*exp(-0.4*ln(xip))
   voltpl:=0
   voltmn:=0
   arczr0:=0
   swdrv:=0
  ENDINIT

  EXEC                  -- fl_sec
-- Secondary Arc Model

  -- Arc conduction circuit
  IF runtim=0 THEN
    voltpl:=0		-- the model is not active
    ELSE
     -- the model was already activated
     -- Model Arc_zero
     arcit:=trunc(ifs*100.0/xip)	-- indication of zero arc current
     IF arcit=0 THEN
       arczr0:=1
      ELSE
       arczr0:=0
     ENDIF
     -- Digital real differantiation
     LAPLACE(lead/arczr0):= 0.001|s / (1| + 0.0002|s)
     ramrst:=lead-4

     -- Model Reignition Voltage
     IF ramrst>=0 THEN
       ramp0:=t
       ramp:=0
      ELSE
       ramp:=t-ramp0
     ENDIF
     varcw:=(5+runtim/xip0)*10000*arc_l*runtim*ramp

     -- Model Logic
     dvarc:=varcw-abs(ufs)
     IF dvarc<2 THEN
       dvarq:=1
      ELSE
       dvarq:=0
     ENDIF
     drvfl:=arczr0-dvarq
     IF drvfl<=0 THEN
       swdrv:=1
      ELSE
       swdrv:=0
     ENDIF

     --
     IF runtim<runtm0 THEN
       voltpl:=vamp_0				-- arc voltage is constant
      ELSE
       voltpl:=vamp_0*(1+10*(runtim-runtm0))	-- arc voltage increases
     ENDIF
     voltmn := -voltpl
  ENDIF
 ENDEXEC
 ENDMODEL                  -- fl_sec
