MODEL SPAR_1
        -- Single Pole Auto-Reclosing model
        -- measurement algorithm (side A)
 INPUT

    iCBAR   -- current at substation A
    iCBBR   -- current at substation B

 OUTPUT
    CB_AR   -- CB at substation A
    CB_BR   -- CB at substation B
    S_FP    -- switch for initiation primary arc
    S_FS    -- switch for initiation secondary arc
    RUNTIM  -- time for control of secondary arc (here as value of current source)

 DATA
    thet_v 
    thet_i 
    N      
    FAINIT 
    CRIMAR
    ISOTIM

  VAR
-- for impedance components measurement

    S_FP
    S_FS
    CB_AR       -- CB at substation A
    CB_BR       -- CB at substation B
    S_FP        -- switch for primary arc
    S_FS        -- switch for secondary arc
    RUNTIM      -- time from initiation of secondary arc
    ISOTM0

   INIT           -- initialization at t=0
-- measurement algorithm

    -- setting of the impulse function of the FIR filters

    CB_AR:=1
    CB_BR:=1
    S_FP:=0
    S_FS:=0
    RUNTIM:=0
    ISOTM0:=0

   ENDINIT       -- SPAR_1

--________________________________
  EXEC                  -- SPAR_1

-- *********************** Main Program ****************************

-- Switches Control

   IF ISOTM0=0 THEN
   -- initiating of a fault (primary arc)
     IF t>FAINIT THEN
      S_FP:=1
     ENDIF
     IF t>ISOTIM THEN           -- CB opening, secondary arc
      IF ABS(iCBAR)<=CRIMAR THEN
       CB_AR:=0
      ENDIF
      IF ABS(iCBBR)<=CRIMAR THEN
       CB_BR:=0
      ENDIF
      IF CB_AR+CB_BR=0 THEN
       S_FP:=0
       S_FS:=1
       ISOTM0:=t
      ENDIF
     ENDIF
    ELSE
     RUNTIM:=t-ISOTM0
   ENDIF

  ENDEXEC
 ENDMODEL               -- SPAR_1
