MODEL DFIG_I -- DFIG model with current control

  DATA
      Ls		   -- machine parameters
      Lr		   -- 
      Lm	           -- 
      Psini		   -- initial value of active power
      Qsini		   -- initial value of rective power
      pole_p		   -- number of pole pairs
  CONST 
      sqrt3 {VAL: sqrt(3)}
      omg_s {VAL: 100*PI}
  INPUT 
      ISTAT[1..3]          -- stator current
      VSTAT[1..3]          -- stator voltage
      IROTR[1..3]	   -- rotor current
      VROTR[1..3]	   -- rotor voltage
      OMEG_R		   -- rotor angular velocity
  OUTPUT 
      S2IN[1..3]
  VAR
      th_r		   -- electrical angle of rotor position
      isD		   -- stator current, D-component
      isQ 
      isx
      isy
      vsD		   -- stator voltage: D-component
      vsQ
      P_s		   -- measured machine active power
      Q_s
      
      irA		   -- rotor current - alpha component
      irB
      ird		   -- rotor current - dq components
      irq
      irx
      iry
      imsD		   -- rotor current induced from stator - DQ components
      imsQ
      ro_s		   -- phase of stator phase-linkage space vector
      Ims		   -- magnitude of stator phase-linkage space vector
      Vs		   -- magnitude of stator voltage
      Lpr
      Lsm
      Xsl
      Xm
      Xs

      ACTP1
      REAP1
      APPP1
      ACTP2
      REAP2
      APPP2

      P_P[1..4]		   -- plan of active power
      Q_Q[1..4]
      T_T[1..4]		   -- time schedule
      P_sref
      Q_sref

      S2IN[1..3]	   -- output control signals

      aD, aQ		   -- aux

--
  INIT
      Lsm:=Ls/Lm
      Lpr:=Lr-Lm/Lsm
      Xm:=omg_s*Lm
      Xs:=omg_s*Ls
      P_P[1..4]:=[Psini, 100000, 200000, 200000]
      Q_Q[1..4]:=[Qsini, 80000, 160000, 160000]
      T_T[1..4]:=[0.44, 1.0, 4.5, 8.0]
      P_sref:=Psini
      Q_sref:=Qsini

  ENDINIT


--
MODEL IM4_C1 -- block of DFIG control
  DATA
      Xm		   -- machine reactance, ohm
      Xs		   -- 
      T_START
  CONST 
      sqrt3 {VAL: sqrt(3)}
      e23 {VAL: 2/3}
  INPUT 
      VSA          	   -- stator voltage at phase A
      V1P		   -- magnitude of stator voltage
      PP1	           -- introduced active power, W
      QQ1		   -- introduced active power, VAr
      THETAE               -- electrical angle of rotor position
  OUTPUT 
      S2INA                -- value of controlled current, phase A
      S2INB
      S2INC

  VAR 
      in1
      vrsq
      sig
      th0
      th1
      
      Xsm
      alph
      aa
      ai
      sn
      cn

      I2D
      I2Q

      S2INA                -- output currents
      S2INB
      S2INC

      STERD
      STERQ

HISTORY
      STERD {dflt:0.001}
      STERQ {dflt:0.001}

  INIT
      histdef(vrsq):=0       -- needed for calculation of prevval()
      in1:=100.0*PI*timestep -- angle step
      th0:=0.0
      Xsm:=Xs/Xm
  ENDINIT

  EXEC                       -- IM4_C1
  -- main procedure
   vrsq:=sign(VSA)           -- sign of phase A stator voltage
   sig:=(vrsq-prevval(vrsq))/timestep

   IF sig>0.0 THEN
     th0:=0.0
    ELSE
     th0:=th0+in1		   -- actual phase of fundamental component waveform
   ENDIF
   
   th1:=ATAN2(QQ1,PP1);		   -- power factor

   alph:=th0+th1-THETAE

   aa:=(PP1*PP1+QQ1*QQ1)/(V1P*V1P)
   ai:=SQRT(aa)
   aa:=aa*Xs
   sn:=Xsm*PP1/aa
   cn:=e23+Xsm*(e23-QQ1/aa)

   -- current space vector
   I2D:=ai*(SIN(alph)*cn-COS(alph)*sn)
   I2Q:=-ai*(COS(alph)*cn+SIN(alph)*sn)
 
   laplace (STERD/I2D) := 1| / (1|s0+0.004|s1)
   laplace (STERQ/I2Q) := 1| / (1|s0+0.004|s1)


   -- output rotor phase currents
   S2INA:=STERD
   S2INB:=(sqrt3*STERQ-STERD)/2
   S2INC:=-(sqrt3*STERQ+STERD)/2

   IF t<T_START THEN
     S2INA:=0
     S2INB:=0 
     S2INC:=0
   ENDIF
  ENDEXEC

 ENDMODEL                  -- IM4_C1

--

  EXEC                     -- DFIG_I
  -- main procedure

  -- looking for current value of power
   IF t>=T_T[4] THEN
     P_sref:=P_P[4]
     Q_sref:=Q_Q[4]
    ELSIF t>=T_T[3] THEN
      P_sref:=P_P[3]
      Q_sref:=Q_Q[3]
     ELSIF t>=T_T[2] THEN
       P_sref:=P_P[2]
       Q_sref:=Q_Q[2]
      ELSIF t>=T_T[1] THEN
        P_sref:=P_P[1]
        Q_sref:=Q_Q[1]
   ENDIF

-- calculation of rotor position

   vsD:=(2*VSTAT[1]-VSTAT[2]-VSTAT[3])/3
   vsQ:=(VSTAT[2]-VSTAT[3])/sqrt3

   isD:=(2*ISTAT[1]-ISTAT[2]-ISTAT[3])/3
   isQ:=(ISTAT[2]-ISTAT[3])/sqrt3
   aD:=isQ*(Xm+Xs)-vsD
   aQ:=isD*(Xm+Xs)+vsQ

   irA:=(2*IROTR[1]-IROTR[2]-IROTR[3])/3	  -- according to original sequence
   irB:=(IROTR[2]-IROTR[3])/sqrt3

   th_r:=ATAN2(irA*aD-irB*aQ, irA*aQ+irB*aD)	  -- electrical angle of rotor

--
   Vs:=norm(vsD,vsQ)


USE IM4_C1 AS IM4_C1
DATA
      Xm:=Xm		   	   -- machine reactance, ohm
      Xs:=Xs		   	   -- 
      T_START:=0.1
  INPUT 
      VSA:=VSTAT[1]     	   -- stator voltage at phase A
      V1P:=Vs			   -- stator voltage magnitude
      PP1:=P_sref	           -- initial active power, W
      QQ1:=Q_sref		   -- initial reactive power, VAr
      THETAE:=th_r		   -- rotor angle
  OUTPUT 
      S2IN[1]:=S2INA               -- sterowana wartosc zrodla pradu, faza A
      S2IN[2]:=S2INB
      S2IN[3]:=S2INC
ENDUSE	-- IM4_C1

   -- these are only auxiliary measurements for info
   P_s:=3*(vsD*isD+vsQ*isQ)/2	   -- machine active power
   Q_s:=3*(vsD*isQ-vsQ*isD)/2

   aD:=cos(th_r)
   aQ:=sin(th_r)
   ird:=irA*aD-irB*aQ
   irq:=irA*aQ+irB*aD

   imsD:=ird+Lsm*isD		  --
   imsQ:=irq+Lsm*isQ		  --
   Ims:=norm(imsD, imsQ)
   ro_s:=atan2(imsQ,imsD)

   aD:=cos(ro_s)
   aQ:=sin(ro_s)
   irx:=ird*aD+irq*aQ
   iry:=irq*aD-ird*aQ

   isx:=(isD*aD+isQ*aQ)
   isy:=(isQ*aD-isD*aQ)

   -- auxiliary measurements
   ACTP1:=VSTAT[1]*ISTAT[1]+VSTAT[2]*ISTAT[2]+VSTAT[3]*ISTAT[3]		-- stator active power
   REAP1:=((VSTAT[3]-VSTAT[2])*ISTAT[1]+(VSTAT[1]-VSTAT[3])*ISTAT[2]	-- stator reactive power
   +(VSTAT[2]-VSTAT[1])*ISTAT[3])/sqrt3
   APPP1:=NORM(ACTP1, REAP1)						-- stator power

   ACTP2:=VROTR[1]*IROTR[1]+VROTR[2]*IROTR[2]+VROTR[3]*IROTR[3]		-- rotor active power
   REAP2:=((VROTR[3]-VROTR[2])*IROTR[1]+(VROTR[1]-VROTR[3])*IROTR[2]	-- rotor reactive power
   +(VROTR[2]-VROTR[1])*IROTR[3])/sqrt3
   APPP2:=NORM(ACTP2, REAP2)						-- rotor power

   ENDEXEC

 ENDMODEL                  -- DFIG_I


