 MODEL T_Diff              -- model zabezpieczenia

-- Zabezpieczenie rnicowe wzdune transformatora

  DATA
      i1zn		   -- prd znamionowy strony H, A
      i1_scl		   -- wspczynnik skali pradowej dla i1
      i2_scl	           -- wspczynnik skali pradowej dla i2
      n			   -- liczba prbek w okresie
      fn		   -- czestotliwosc znamionowa
  CONST 
      sqrt3 {VAL: sqrt(3)}
  INPUT 
      i1r,i1s,i1t          -- prd strony 1 trafo, fazy R, S, T
      i2r,i2s,i2t          -- prd strony 2 trafo
      i1i		   -- skadowa urojona prdu w fazie R (warto pocztkowa)
  OUTPUT 
      s_trip               -- sygna wyjciowy
  VAR 
      t1                   -- czas pobrania nastpnej prbki,s
      del                  -- okres prbkowania, s
      itr,its,itt          -- prdy wzdune (hamujce)
      it1r,it1s,it1t       -- amplitudy prdw wzdunych

      idr,ids,idt          -- prdy rnicowe
      id1r,id1s,id1t       -- amplituda 1-szej harm. prdu rnicowego
      id2r,id2s,id2t       -- amplituda 2-giej harm. prdu rnicowego
      id5r,id5s,id5t       -- amplituda 5-tej harm. prdu rnicowego
      itrs,itrc,itss,itsc,itts,ittc 
      d1rs,d1rc,d1ss,d1sc,d1ts,d1tc       
      d2rs,d2rc,d2ss,d2sc,d2ts,d2tc             
      d5rs,d5rc,d5ss,d5sc,d5ts,d5tc       

      hs1[1..n]            -- funkcja impulsowa sinusowego filtru 1-ej harm.
      hc1[1..n]            -- funkcja impulsowa kosinusowego filtru 1-ej harm.
      hs2[1..n]           
      hc2[1..n]           
      hs5[1..n]           
      hc5[1..n]

      gtrs[1..n],gtss[1..n],gtts[1..n] -- pomoc. zmienne filtru sin. 1-ej harm. 
      gtrc[1..n],gtsc[1..n],gttc[1..n] -- pomoc. zmienne filtru cos. 1-ej harm. 
      grs1[1..n],gss1[1..n],gts1[1..n]
      grc1[1..n],gsc1[1..n],gtc1[1..n]
      grs2[1..n],gss2[1..n],gts2[1..n]
      grc2[1..n],gsc2[1..n],gtc2[1..n]
      grs5[1..n],gss5[1..n],gts5[1..n]
      grc5[1..n],gsc5[1..n],gtc5[1..n]

      rl1r,rl1s,rl1t       -- pomocnicze wskaniki zabezpieczenia
      rl2r,rl2s,rl2t      
      trpr, trps, trpt
      s_trip               -- sygna wyjciowy zabezpieczenia

      i,j,tm               -- indeksy pomocnicze
      a,b                  -- zmienne pomocnicze
      a1,b1                --

  INIT                     -- warunki pocztkowe, t=0 
      t1:=0
      tm:=1
      del:=1/(fn*n)        -- okres prbkowania

      -- charakterystyki impulsowe filtrw skadowych harmonicznych
      b:=2/n
      a1:=b*pi
      FOR k:=1 TO n/2 DO
	a:=a1*(k-0.5)
	hs1[k]:=-b*sin(a)
	hc1[k]:=-b*cos(a)
	hs2[k]:=b*sin(2*a)
	hc2[k]:=b*cos(2*a)
	hs5[k]:=-b*sin(5*a)
	hc5[k]:=-b*cos(5*a)
      ENDFOR

      i:=n+1
      FOR j:=1+n/2 TO n DO
        hs1[j]:=-hs1[i-j]
        hc1[j]:=hc1[i-j]
        hs2[j]:=-hs2[i-j]
        hc2[j]:=hc2[i-j]
        hs5[j]:=-hs5[i-j]
        hc5[j]:=hc5[i-j]
      ENDFOR

      d1rs:=0,d1rc:=0,d1ss:=0,d1sc:=0,d1ts:=0,d1tc:=0
      d2rs:=0,d2rc:=0,d2ss:=0,d2sc:=0,d2ts:=0,d2tc:=0             
      d5rs:=0,d5rc:=0,d5ss:=0,d5sc:=0,d5ts:=0,d5tc:=0       
      id1r:=0,id1s:=0,id1t:=0
      id2r:=0,id2s:=0,id2t:=0  
      id5r:=0,id5s:=0,id5t:=0  
      grs1[1..n]:=0,gss1[1..n]:=0,gts1[1..n]:=0 
      grc1[1..n]:=0,gsc1[1..n]:=0,gtc1[1..n]:=0 
      grs2[1..n]:=0,gss2[1..n]:=0,gts2[1..n]:=0
      grc2[1..n]:=0,gsc2[1..n]:=0,gtc2[1..n]:=0
      grs5[1..n]:=0,gss5[1..n]:=0,gts5[1..n]:=0
      grc5[1..n]:=0,gsc5[1..n]:=0,gtc5[1..n]:=0

  ENDINIT

 MODEL magnit              -- obliczanie amplitudy skadowych harmonicznych
                           -- za pomoc algorytmu korelacyjnego
  DATA m                   -- liczba faz
  INPUT 
        hs,hc              -- funkcje impulsowe filtrw
        x[1..m]            -- sygnay wejciowe
        g1[1..m],g2[1..m]  --
        y1[1..m],y2[1..m] 
  VAR 
        gs[1..m],gc[1..m]  --
        ys[1..m],yc[1..m] 
        am[1..m]
  OUTPUT
        gs[1..m],gc[1..m]  --
        ys[1..m],yc[1..m] 
        am[1..m]
  EXEC                     -- magnit
   FOR k:=1 TO m DO
    gs[k]:=x[k]*hs
    ys[k]:=y1[k]+gs[k]-g1[k]
    gc[k]:=x[k]*hc
    yc[k]:=y2[k]+gc[k]-g2[k]
    am[k]:=norm(ys[k],yc[k])
   ENDFOR
  ENDEXEC
 ENDMODEL                  -- magnit

 MODEL diffpt              -- zabezpieczenie rnicowe trafo: gwna procedura
  DATA
      m                    -- liczba faz
      in		   -- prd znamionowy strony H, A
  CONST 
      indx {VAL: 3}
      ins  {VAL: -2}       -- warto pocz. rel1[]
      inc  {VAL: 2}        -- warto pocz. rel2[]
      ms   {VAL: 2}        -- liczba prbek do kasowania pobudzenia
  INPUT 
    id1[1..m],id2[1..m],id5[1..m]    
    it1[1..m]  
  VAR 
    a0,a1,a2,b0,b1,b2
    k1,k2
    c1,c2,y,ms1[1..m]
    rel1[1..m],rel2[1..m],trip[1..m] 
  OUTPUT
    rel1[1..m],rel2[1..m],trip[1..m]
  INIT
    -- nastawy zabezpieczenia: charakterystyka rnicowa
    k1:=sqrt(2.0)*in	   -- amplituda prdu znam. po stronie H
    a0:=0.2*k1		   -- prg pobudzenia
--    a1:=3.0*k1
--    a2:=15.0*k1
    a0:=0.1*k1
    a1:=1.0*k1
    a2:=2.5*k1
    b0:=0.2*k1
    c1:=0.15
    c2:=0.2
    k1:=0.4
    k2:=2.0*k1
    b1:=b0+(a1-a0)/k1
    b2:=b1+(a2-a1)/k2
    rel1[1..m]:=ins	   -- historia 
    rel2[1..m]:=inc
    trip[1..m]:=0         
    ms1[1..m]:=0
  ENDINIT
  EXEC                    -- diffpt
   -- spradzanie warunkw kryterialnych dla wszystkich m faz
   FOR k:=1 TO m DO
    IF id1[k]>a0 THEN	  -- jeli pobudzenie 
     -- korekcja historii
     DO rel1[k]:=ins+1; ms1[k]:=ms ENDDO
     ELSE DO IF ms1[k]>0 THEN 
              DO ms1[k]:=ms1[k]-1; IF ms1[k]=0 THEN rel1[k]:=ins ENDIF 
              ENDDO 
             ENDIF
          ENDDO
    ENDIF
    IF rel1[k]=ins+1 THEN
     DO 
      IF id1[k]>a2 THEN rel2[k]:=inc+indx ELSE
       DO 
        IF it1[k]<b0 THEN y:=a0 ELSE
         DO IF it1[k]<b1 THEN y:=a0+(it1[k]-b0)*k1 ELSE
             DO IF it1[k]<b2 THEN y:=a1+(it1[k]-b1)*k2 ELSE y:=a2 ENDIF
             ENDDO
            ENDIF
         ENDDO
        ENDIF
        IF id1[k]>y THEN                      -- f(it1)
         -- sprawdzenie warunkw blokady od 2-iej i 5-tej harmonicznej
         DO IF id2[k]<c1*id1[k] THEN
              DO IF id5[k]<c2*id1[k] THEN 
                    DO IF rel2[k]<indx+inc THEN rel2[k]:=rel2[k]+1 ENDIF
                    ENDDO ELSE rel2[k]:=inc
                 ENDIF
              ENDDO ELSE rel2[k]:=inc
            ENDIF
         ENDDO ELSE rel2[k]:=inc
        ENDIF
       ENDDO
      ENDIF
     ENDDO ELSE rel2[k]:=inc
    ENDIF
    IF rel2[k]=inc+indx THEN trip[k]:=1 ENDIF
   ENDFOR
  ENDEXEC
 ENDMODEL                  -- diffpt

  EXEC                     -- T_Diff
  -- gwna procedura
 
  IF t=0 THEN              -- pierwszy krok: stan ustalony algorytmu
   -- warunki pocztkowe dla filtrw
   itrs:=0,itrc:=0,itss:=0,itsc:=0,itts:=0,ittc:=0 
   a:=norm(i1r,i1i)
   IF ABS(i1i)+ABS(i1r)=0 THEN a1:=0 ELSE a1:=atan2(i1i,i1r) ENDIF         
   FOR i:=1 TO n DO
    b1:=2*pi*((i-2.68)/n)
    b:=a*cos(b1+a1);
    gtrs[i]:=b*hs1[i]
    gtrc[i]:=b*hc1[i]
    itrs:=itrs+gtrs[i]
    itrc:=itrc+gtrc[i]     
    b:=a*cos(b1+a1-2*pi/3)
    gtss[i]:=b*hs1[i]
    gtsc[i]:=b*hc1[i]
    itss:=itss+gtss[i]
    itsc:=itsc+gtsc[i]     
    b:=a*cos(b1+a1+2*pi/3)
    gtts[i]:=b*hs1[i]
    gttc[i]:=b*hc1[i]
    itts:=itts+gtts[i]
    ittc:=ittc+gttc[i]     
   ENDFOR
  ENDIF

  IF abs(t-t1)<timestep THEN            -- prbkowanie
 
         b:=(i2r+i2s+i2t)/3		-- skadowa zerowa
         -- obliczenie prdu rnicowego
         idr:=i2_scl*(i2r-b)-i1_scl*(i1r-i1t)/sqrt3
         ids:=i2_scl*(i2s-b)-i1_scl*(i1s-i1r)/sqrt3
         idt:=i2_scl*(i2t-b)-i1_scl*(i1t-i1s)/sqrt3

         -- obliczenie prdu wzdunego (hamujcego)
         itr:=(i2_scl*(i2r-b)+i1_scl*(i1r-i1t)/sqrt3)/2
         its:=(i2_scl*(i2s-b)+i1_scl*(i1s-i1r)/sqrt3)/2
         itt:=(i2_scl*(i2t-b)+i1_scl*(i1t-i1s)/sqrt3)/2

   -- amplituda 1-szej harmonicznej: prd wzduny i rnicowy
   USE magnit AS magnit    -- amplituda 1-szj harmonicznej
    DATA
     m:=6                  -- liczba sygnaw
    INPUT
     hs:=hs1[tm], hc:=hc1[tm]
     x[1..6]:=[itr,its,itt,idr,ids,idt]
     g1[1..3]:=[gtrs[tm],gtss[tm],gtts[tm]]
     g1[4..6]:=[grs1[tm],gss1[tm],gts1[tm]]
     g2[1..3]:=[gtrc[tm],gtsc[tm],gttc[tm]]
     g2[4..6]:=[grc1[tm],gsc1[tm],gtc1[tm]]
     y1[1..6]:=[itrs,itss,itts,d1rs,d1ss,d1ts]
     y2[1..6]:=[itrc,itsc,ittc,d1rc,d1sc,d1tc]      
    OUTPUT
     gtrs[tm]:=gs[1], gtss[tm]:=gs[2], gtts[tm]:=gs[3]
     grs1[tm]:=gs[4], gss1[tm]:=gs[5], gts1[tm]:=gs[6]
     gtrc[tm]:=gc[1], gtsc[tm]:=gc[2], gttc[tm]:=gc[3]
     grc1[tm]:=gc[4], gsc1[tm]:=gc[5], gtc1[tm]:=gc[6]
     itrs:=ys[1], itss:=ys[2], itts:=ys[3]
     d1rs:=ys[4], d1ss:=ys[5], d1ts:=ys[6]
     itrc:=yc[1], itsc:=yc[2], ittc:=yc[3]
     d1rc:=yc[4], d1sc:=yc[5], d1tc:=yc[6]
     it1r:=am[1], it1s:=am[2], it1t:=am[3]
     id1r:=am[4], id1s:=am[5], id1t:=am[6]
   ENDUSE

   -- amplituda 2-iej harmonicznej prdu rnicowego
   USE magnit AS magnit    
    DATA
     m:=3                  -- liczba sygnaw
    INPUT
     hs:=hs2[tm], hc:=hc2[tm]
     x[1..3]:=[idr,ids,idt]
     g1[1..3]:=[grs2[tm],gss2[tm],gts2[tm]]
     g2[1..3]:=[grc2[tm],gsc2[tm],gtc2[tm]]
     y1[1..3]:=[d2rs,d2ss,d2ts]
     y2[1..3]:=[d2rc,d2sc,d2tc]      
    OUTPUT
     grs2[tm]:=gs[1], gss2[tm]:=gs[2], gts2[tm]:=gs[3]
     grc2[tm]:=gc[1], gsc2[tm]:=gc[2], gtc2[tm]:=gc[3]
     d2rs:=ys[1], d2ss:=ys[2], d2ts:=ys[3]
     d2rc:=yc[1], d2sc:=yc[2], d2tc:=yc[3]
     id2r:=am[1], id2s:=am[2], id2t:=am[3]
   ENDUSE

   -- amplituda 5-tej harmonicznej prdu rnicowego
   USE magnit AS magnit    
    DATA
     m:=3                  -- liczba sygnaw
    INPUT
     hs:=hs5[tm], hc:=hc5[tm]
     x[1..3]:=[idr,ids,idt]
     g1[1..3]:=[grs5[tm],gss5[tm],gts5[tm]]
     g2[1..3]:=[grc5[tm],gsc5[tm],gtc5[tm]]
     y1[1..3]:=[d5rs,d5ss,d5ts]
     y2[1..3]:=[d5rc,d5sc,d5tc]      
    OUTPUT
     grs5[tm]:=gs[1], gss5[tm]:=gs[2], gts5[tm]:=gs[3]
     grc5[tm]:=gc[1], gsc5[tm]:=gc[2], gtc5[tm]:=gc[3]
     d5rs:=ys[1], d5ss:=ys[2], d5ts:=ys[3]
     d5rc:=yc[1], d5sc:=yc[2], d5tc:=yc[3]
     id5r:=am[1], id5s:=am[2], id5t:=am[3]
   ENDUSE

   -- zabezpieczenie rnicowe transformatora     
   USE diffpt AS diffpt    
    DATA
     m:=3                  -- liczba sygnaw (3 fazy)
     in:=i1zn		   -- prd znamionowy strony H
    INPUT
     id1[1..3]:=[id1r,id1s,id1t]       
     id2[1..3]:=[id2r,id2s,id2t]         
     id5[1..3]:=[id5r,id5s,id5t]    
     it1[1..3]:=[it1r,it1s,it1t]    
    OUTPUT
     rl1r:=rel1[1], rl1s:=rel1[2], rl1t:=rel1[3]
     rl2r:=rel2[1], rl2s:=rel2[2], rl2t:=rel2[3]      
     trpr:=trip[1], trps:=trip[2], trpt:=trip[3]
   ENDUSE

   s_trip:=trpr OR trps OR trpt -- sygna wyjciowy na wycznik

   tm:=tm+1
   IF tm>n THEN tm:=1 ENDIF
   t1:=t1+del		   -- przygotowanie do nastpnej prbki
  ENDIF
 ENDEXEC
 ENDMODEL                  -- T_Diff

