MODEL DFIG_W -- DFIG model with rotor voltage control
		-- Two PI control loops
		-- measurements and transformation convention: U=ual+j*ube; U=ud+j*uq; U=ux+j*uy

  DATA
      Lls		   -- stator inductance, H
      Llr		   -- rotor inductance, H
      Lm	         -- magnetizing inductance, H
      Rs	         -- stator resistance, ohm
      Rr	         -- rotor resistance, ohm
      pole_p	   -- number of pole pairs
      Vn		   -- nominal voltage, V
      slip		   -- initial rotor slip, %
      Rv             -- resistance in the mechanical model, ohm
      Sn		   -- nominal power
      Pnini		   -- iniatial active power, W
      Qnini		   -- initial reactive power, VA
      Tn1		   -- PI1 time constant (outer controller), s
      Tn2		   -- PI2 time constant (inner controller), s
      
  CONST 
      sqrt3 {VAL: sqrt(3)}
      omg_s {VAL: 100*PI}
      pi2   {VAL: 2*PI}
      k_obs {VAL: 0.019513}	-- gain of the observer filter
          
  INPUT 
      ISTAT[1..3]          -- stator currents
      VSTAT[1..3]          -- stator voltage
      IROTR[1..3]
      OMEG_R		   -- rotor angular velocity
 
  OUTPUT 
      VS_OUT[1..3]	   -- voltage source control
      T_WIND		   -- windmill moment

  VAR
      k_Pn
      Vs_al		   	-- alpha-beta coordinates of stator voltage
      Vs_be
      Is_al		 	-- alpha-beta coordinates of stator current
      Is_be

      sigm
      Xs
      Xm
      sigm1
      Lrp
                                                
      Pn		   -- machine active power at the network connection (total power)
      Qn
      Pr
      Qr
      Pn1
      Qn1
 
      dPn
      dQn

      dPmax
      Irxref	   -- reference rotor current in x-y coordinates
      Iryref

      omg_r		   -- rotor electrical angle velocity
      om_sl		   -- slip angle velocity
      th_r
     
      Irx
      Iry
      Vrx		   -- rotor voltage in x-y coordinates
      Vry
      
      Ird
      Irq

      Ismq
      Ismd

      Ism		   -- magnitude of stator phase-linkage space vector
      Vs		   -- magnitude of stator voltage
      
      Lsm
      Lr
      Ls
      Xsl

      KI_IX
      KI_IY
      KI_VX
      KI_VY
      Vprx
      Vpry

      Vdrx
      Vdry
      Vpra
      Vprb
      Vr_al
      Vr_be
      Ir_al
      Ir_be

      Is2
      ab
      aa
      ac

      a1
      a2
      a3
      a4
      cs
      ss
      
      VS_OUT[1..3]	  -- output voltage source
      T_WIND		  -- output windmill moment

      P_P[1..6]		  -- active power
      Q_Q[1..6]		  -- reactive power
      T_M[1..6]		  -- windmill torque 
      T_T[1..6]		  -- time

      P_nref		  -- reference power
      Q_nref
      TLini		  -- initial torque

      KP_1		  -- outer regulator settings
      KI_1
      KP_2		  -- inner regulator settings
      KI_2

      fp
      afp		  -- coeffcients of power measuring filters
      bfp

      cs_thr
      sn_thr
      
      cg_sm		  -- COS(gam_sm)
      sg_sm		  -- SIN(gam_sm)

      k_sigm
 
  INIT

      fp:=0.2/timestep
      afp:=2*pi*fp	  	-- coefficients of power measuring filters
      bfp:=afp*afp
      afp:=sqrt(2)*afp

      k_Pn:=1		  	-- stator and rotor power included

      Lr:=Llr+Lm
      Ls:=Lls+Lm
      Lsm:=Ls/Lm

      dPmax:=0.16*Sn		-- max increasing power in Tapia method: 16% of Sn
 
      Xs:=omg_s*Ls
      Xm:=omg_s*Lm

      sigm:=1-Lm*Lm/(Ls*Lr)
      k_sigm:=3*Lm/(2*sigm*Ls*Lr)
     write('Ls=',Ls,' Lr=',Lr,' Lm=',Lm,' sigm=',sigm)

      Lrp:=sigm*Lr
      sigm1:=(1-sigm)/sigm
     -- regulators setting calculation
      KP_2:=sigm*Lr/Tn2		-- regulator coeff. for inner control loop (rotor current)
      KI_2:=Rr/Tn2

     -- regulator coeff. for outer control loop (P and Q)
      KI_1:=3.0*Vn*SQRT(2.0)/(2*sqrt3*Lsm)

      KI_1:=1/(Tn1*KI_1)
      KP_1:=Tn2*KI_1


     write('KP_1=',KP_1,' KI_1=',KI_1,' Tn1=',Tn1)
     write('KP_2=',KP_2,' KI_2=',KI_2,' Tn2=',Tn2)

      P_nref:=Pnini
      Q_nref:=Qnini

     -- calculation of initial rotor position th_r
   
      Vs_al:=(2*VSTAT[1]-VSTAT[2]-VSTAT[3])/3     -- components of stator voltage space phasor
      Vs_be:=(VSTAT[2]-VSTAT[3])/sqrt3

      Vs:=norm(Vs_al,Vs_be)			  -- stator voltage
      histdef(Vs):=Vs
 
      Is_al:=(2*ISTAT[1]-ISTAT[2]-ISTAT[3])/3     -- components of stator current space phasor
      Is_be:=(ISTAT[2]-ISTAT[3])/sqrt3

      ab:=omg_s*timestep
      aa:=cos(ab)
      ab:=sin(ab)

      Ir_al:=(2*IROTR[1]-IROTR[2]-IROTR[3])/3     -- components of rotor current space phasor
      Ir_be:=(IROTR[2]-IROTR[3])/sqrt3

      om_sl:=slip*omg_s/100
      omg_r:=omg_s-om_sl

      aa:=(Xs*Is_al+Rs*Is_be+Vs_be)/Xm
      ab:=(Rs*Is_al-Xs*Is_be+Vs_al)/Xm
      a4:=NORM(Ir_al,Ir_be)
      a1:=NORM(aa,ab)
      sn_thr:=a4*a1
      cs_thr:=(Ir_al*aa-Ir_be*ab)/sn_thr	  -- COS(th_r)
      sn_thr:=-(Ir_be*aa+Ir_al*ab)/sn_thr	  -- SIN(th_r)
      th_r:=ATAN2(sn_thr,cs_thr)
      histdef(th_r):=th_r

    write('th_r=',atan2(sn_thr,cs_thr))
    write('Ir_al=',Ir_al,' Ir_be=',Ir_be,' - from measurement')
    write('Is_al=',Is_al,' Is_be=',Is_be,' - from measurement')
      ac:=Ir_al*Ir_al+Ir_be*Ir_be
      aa:=sqrt(ac)			-- needed current magnitude in the current source
      ab:=180*atan2(-Ir_be,Ir_al)/pi	-- needed current angle

    write('|Ir|=',aa,' angle=',ab,' - from measurement')


      -- initializing of Ism, Irx, Iry

      Is2:=Is_al*Is_al+Is_be*Is_be

      -- rotor power is included

      a1:=100*Lm/(slip*Lr)-(1+sigm)*Lsm			-- E
      a2:=2*Q_nref/(3*om_sl*Lr)+sigm*Lsm*Lsm*Is2	-- F
--      a3:=2*Rs/(omg_s*Lm)				-- G
      a3:=-2*Rs/(omg_s*Lm)				-- G

      a4:=P_nref+3*Is2*(Rs+Rr*Lsm*Lsm)/2		-- D
      Pn:=a3*a3/4
      Pn:=Pn*(Vs*Vs/(Rs*Rs)-Is2)			-- H
      aa:=3*Rr*Lsm					-- A

      ab:=3*Lm*omg_r/2					-- B

      ac:=3*Rr/2						-- C

      IF k_Pn=0 THEN
       a1:=omg_s*Lm
       a2:=2*Q_nref/3
       a4:=P_nref+3*Is2*Rs/2
       aa:=0
       ab:=3*a1/2
       ac:=0
      ENDIF

      Qn:=aa*a3-ab*a1-ac*a1*a3
      Ism:=(a4*a1*a3-a2*aa*a3-Pn*ab*a1)/Qn	-- Ism2

      Ird:=(a2+k_Pn*Ism)/a1			-- alpha  (Isx)
      Irq:=(Pn-Ism)/a3				-- beta  (Isy)

      Ism:=sqrt(Ism)
      Ird:=Ird/Ism	-- Isx
      Irq:=Irq/Ism	-- Isy
      Irx:=Ism+Lsm*Ird
      Iry:=Lsm*Irq
    write('Isx=',Ird,' Isy=',Irq,' Ism1=',Ism)

   -- calculation of the magnetizing current
 
      Ird:=(cs_thr*Ir_al-sn_thr*Ir_be)
      Irq:=(cs_thr*Ir_be+sn_thr*Ir_al)

      Ismd:=Ird-Lsm*Is_al
      Ismq:=Irq-Lsm*Is_be
      Ism:=NORM(Ismq,Ismd)

      cg_sm:=Ismd/Ism				-- COS(gam_sm)
      sg_sm:=Ismq/Ism				-- SIN(gam_sm)

write('Vs_al=',Vs_al,' Vs_be=',Vs_be,' gam_sm=',ATAN2(Ismq,Ismd))
write('Is_al=',Is_al,' Is_be=',Is_be,' Isab=',sqrt(Is_al*Is_al+Is_be*Is_be))
write('Ird=',Ird,' Irq=',Irq)

write('Irx=',Irx,' Iry=',Iry,' Ism2=',Ism,' Lrp=',Lrp)

      histdef(KI_IX):=Irx
      histdef(KI_IY):=Iry
      histdef(KI_VX):=Rr*Irx
      histdef(KI_VY):=Rr*Iry

      Xsl:=om_sl*Lrp
      Vrx:=Rr*Irx-Xsl*Iry
      Vry:=Rr*Iry+om_sl*Lm*Ism/Lsm+Xsl*Irx

write('Vrx=',Vrx,' Vry=',Vry,' om_sl=',om_sl)
     
      -- calculation of needed rotor current source

      aa:=cg_sm*cs_thr+sg_sm*sn_thr		  -- COS(gam_sm-th_r)
      ac:=sg_sm*cs_thr-cg_sm*sn_thr

      Ir_al:=Irx*aa-Iry*ac			-- Ir_al
      Ir_be:=Irx*ac+Iry*aa			-- Ir_be
write('cos=',aa,' sin=',ac,' - gam_sm-th_r')
write('Ir_al=',Ir_al,' Ir_be=',Ir_be,' - estimated')
      ac:=Irx*Irx+Iry*Iry
      aa:=sqrt(ac)			-- needed current magnitude in the current source
      ab:=180*atan2(-Ir_be,Ir_al)/pi	-- needed current angle
    write('|Ir|=',aa,' angle=',ab)

      -- stator power
      Pn:=3*Vs*Iry/(2*Lsm)
      Qn:=3*Vs*(Irx-Ism)/(2*Lsm)

      -- initial load torque
      TLini:=pole_p*Pn/omg_r-omg_r/(pole_p*Rv)-3*pole_p*(Rs*Is2)/(2*omg_r)
      IF k_Pn THEN
        Pr:=-3*(Vrx*Irx+Vry*Iry)/2	-- rotor active power
        Qr:=-3*(Vry*Irx-Vrx*Iry)/2	-- rotor reactive power
        Pn:=Pn+Pr
        Qn:=Qn+Qr
write('Pr=',Pr,' Qr=',Qr)
        TLini:=TLini-3*pole_p*(Rr*ac)/(2*omg_r)
      ENDIF
      histdef(Pn):=Pn
      histdef(Qn):=Qn

write('omg_r=',omg_r)
write('Pn=',Pn,' Qn=',Qn,' Vs=',Vs)

write('Te=',pole_p*Pn/omg_r)			-- electromagnetic torque
write('Tv=',omg_r/(pole_p*Rv))			-- friction losses torque
write('TRs=',3*pole_p*(Rs*Is2)/(2*omg_r))	-- active power losses in stator
write('TRr=',3*pole_p*(Rr*ac)/(2*omg_r))	-- active power losses in rotor
-- TL_ini should be put into the machine mechanical model
write('T_Lini=',TLini)
      T_WIND:=0

      P_P[1..6]:=[Pnini, 1800000, 2000000, 1200000, 1200000 Pnini]
      Q_Q[1..6]:=[Qnini, -1400000, -1500000, -600000, 500000 Qnini]
      T_M[1..6]:=[T_WIND, T_WIND, 2000.0, 12500.0, 11500.0, T_WIND]
      T_T[1..6]:=[0.0, 2.0, 4.0, 7.0, 11.0 16.0]	-- time table, s
  ENDINIT

--

  EXEC                     -- DFIG_V
-- main procedure

  -- looking for current value of power
  IF t>=T_T[6] THEN
   P_nref:=P_P[6]
   Q_nref:=Q_Q[6]
   T_WIND:=T_M[6]
   ELSIF t>=T_T[5] THEN
    P_nref:=P_P[5]
    Q_nref:=Q_Q[5]
    T_WIND:=T_M[5]
    ELSIF t>=T_T[4] THEN
     P_nref:=P_P[4]
     Q_nref:=Q_Q[4]
     T_WIND:=T_M[4]
     ELSIF t>=T_T[3] THEN
      P_nref:=P_P[3]
      Q_nref:=Q_Q[3]
      T_WIND:=T_M[3]
      ELSIF t>=T_T[2] THEN
       P_nref:=P_P[2]
       Q_nref:=Q_Q[2]
       T_WIND:=T_M[2]
  ENDIF

   omg_r:=pole_p*OMEG_R					-- rotor electrical speed

-- calculation of rotor position

   laplace (th_r/omg_r) := 1| / (0|s0+1|s1) 	-- electrical angle of rotor
   cs_thr:=COS(th_r)
   sn_thr:=SIN(th_r)

   Vs_al:=(2*VSTAT[1]-VSTAT[2]-VSTAT[3])/3      -- components of stator voltage space phasor
   Vs_be:=(VSTAT[2]-VSTAT[3])/sqrt3               

   Vs:=norm(Vs_al,Vs_be)

   Is_al:=(2*ISTAT[1]-ISTAT[2]-ISTAT[3])/3      -- components of stator current space phasor
   Is_be:=(ISTAT[2]-ISTAT[3])/sqrt3

   Ir_al:=(2*IROTR[1]-IROTR[2]-IROTR[3])/3     	-- components of rotor current space phasor
   Ir_be:=(IROTR[2]-IROTR[3])/sqrt3

-- calculation of the magnetizing current
 
   Ird:=(cs_thr*Ir_al-sn_thr*Ir_be)
   Irq:=(cs_thr*Ir_be+sn_thr*Ir_al)

   Ismd:=Ird-Lsm*Is_al
   Ismq:=Irq-Lsm*Is_be
   Ism:=NORM(Ismq,Ismd)

-- calculation of angle gam_sm
   cg_sm:=Ismd/Ism				-- COS(gam_sm)
   sg_sm:=Ismq/Ism				-- SIN(gam_sm)

   -- rotor current in x-y

   Irx:=(cg_sm*Ird+sg_sm*Irq)
   Iry:=(cg_sm*Irq-sg_sm*Ird)

   om_sl:=omg_s-omg_r				-- slip calculation

-- calculation of stator power

   Pn1:=3*(Vs_al*Is_al+Vs_be*Is_be)/2		-- stator power
   Qn1:=3*(Vs_be*Is_al-Vs_al*Is_be)/2

   IF k_Pn THEN
     Pn1:=Pn1+Pr
     Qn1:=Qn1+Qr
   ENDIF
   -- antialiasing filters with limitations for power measuring
   CLAPLACE (Pn/Pn1) := bfp| / (bfp|s0+afp|s1+1|s2)
   CLAPLACE (Qn/Qn1) := bfp| / (bfp|s0+afp|s1+1|s2)

   -- Power PI_1 regulator: outer control-loop

   dPn:=(P_nref-Pn) {min:-dPmax max: dPmax}
   dQn:=(Q_nref-Qn) {min:-dPmax max: dPmax}

   laplace (KI_IX/dQn) := KI_1| / (0|s0+1|s1)
   Irxref:=KI_IX+KP_1*dQn

   laplace (KI_IY/dPn) := KI_1| / (0|s0+1|s1)
   Iryref:=KI_IY+KP_1*dPn

   -- Voltage PI_2 regulator: inner control loop

   Vpra:=Irxref-Irx
   Vprb:=Iryref-Iry

   laplace (KI_VX/Vpra) := KI_2| / (0|s0+1|s1)
   Vprx:=KI_VX+KP_2*Vpra

   laplace (KI_VY/Vprb) := KI_2| / (0|s0+1|s1)
   Vpry:=KI_VY+KP_2*Vprb

   Xsl:=om_sl*Lrp
   Vdrx:=-Xsl*Iry
   Vdry:=Xsl*(sigm1*Ism+Irx)

   Vrx:=Vdrx+Vprx
   Vry:=Vdry+Vpry

   IF k_Pn THEN
    Pr:=-3*(Vrx*Irx+Vry*Iry)/2	-- rotor active power
    Qr:=-3*(Vry*Irx-Vrx*Iry)/2	-- rotor reactive power
   ENDIF

   -- output control voltage

   aa:=cg_sm*cs_thr+sg_sm*sn_thr		  -- COS(gam_sm-th_r)
   ac:=sg_sm*cs_thr-cg_sm*sn_thr

   Vr_al:=(Vrx*aa-Vry*ac)        	          -- output rotor voltage in al-bet coordinates
   Vr_be:=(Vrx*ac+Vry*aa)

   VS_OUT[1]:=Vr_al				  -- output rotor voltage in phase coordinates
   VS_OUT[2]:=(sqrt3*Vr_be-Vr_al)/2
   VS_OUT[3]:=-(sqrt3*Vr_be+Vr_al)/2

 ENDEXEC

 ENDMODEL                  -- DFIG_W

