% program for presentation of the line frequency characteristic
% contained in *.lis file

clear all

    NEWL=abs([13 10]);
    [getfile,pat] = uigetfile('*.lis','Get Data File for Modification');
    if getfile == 0, return; end;
    k=size(pat);
    FILEPATH=pat(1:(k(2)-1));
    FILENAME=getfile;
    fid=fopen([pat getfile]);
    MFILE=fread(fid);
    MFILE=sprintf('%s',MFILE);
    k=findstr(MFILE,' Neper/km  ');
    l1=size(k,2);
    l2=size(MFILE,2);
    MFILE=MFILE(k(1,l1):l2);
    k=findstr(MFILE,NEWL);
    l1=size(k,2);
    l2=1;
    m=1;
    while l2,
     if l1>2,
       p=str2num(MFILE(k(1,m)+2:k(1,m+1)));
       if ~isempty(p),   
         nn(m,:)=p;
         m=m+1;
        else,
         l2=0;
       end;
      else,
       ['error'], return;
     end;
    end;
% Results:
%  --------------  Zero sequence  ----------------              -------------  Positive sequence  -------------
%    Alpha        Beta        R        L(milli-    C(micro-      Alpha        Beta        R        L(milli-    C(micro-    Frequency
% Neper/km    Radian/km    Ohm/km    Henry/km)   Farad/km)    Neper/km    Radian/km    Ohm/km     Henry/km)   Farad/km)       Hz
%
    k=size(nn,1);
    f=nn(:,11);
    gg=0.03*1E-6;
    c0=nn(k,5);
    l0=nn(k,4);
    c1=nn(k,10);
    l1=nn(k,9);
    ll=180;	% dlugosc linii
    v0=1/sqrt(l0*c0*1E-9);
    v1=1/sqrt(l1*c1*1E-9);
    b00=ll*2*pi*f/v0;
    b01=ll*2*pi*f/v1;
    ta0=ll/v0;
    ta1=ll/v1;
 
     % A(w)
    j=sqrt(-1);
    aw0=exp(-(nn(:,1)+j*nn(:,2))*ll);
    z0=(nn(:,3)+j*2*pi*f.*nn(:,4)/1000);
    y0=gg+j*2*pi*f.*nn(:,5)/1E6;
    zf0=sqrt(z0./y0);
    aw1=exp(-(nn(:,6)+j*nn(:,7))*ll);
    z1=(nn(:,8)+j*2*pi*f.*nn(:,9)/1000);
    y1=j*2*pi*f.*nn(:,10)/1E6;
    zf1=sqrt(z1./y1);
    semilogx(f,abs(aw0),f,abs(aw1));
    title('|A(w)|');
    grid;
    figure;
    % plotting imag
%    loglog(f,unwrap(angle(aw0)),f,unwrap(angle(aw1)));
    loglog(f,-ll*nn(:,2),f,-ll*nn(:,7));
    title('arg(A(w))');
    grid;
   % plotting korekta
    figure;
%    loglog(f,unwrap(angle(aw0)),f,unwrap(angle(aw1)));
    
    semilogx(f,-(ll*nn(:,2)-b00)/pi,f,-(ll*nn(:,7)-b01)/pi);
    title('arg(A(w))');
    grid;
 


