% rozchodzenie sie fali w linii
% dane z: *.lis file 

clear all;

% dla f=2000 Hz:

dane_l0=[0 0 2.0075 1.968 7.7290E-03];
dane_l1=[0 0 9.619E-02 1.0194E+00 1.1230E-02];

f=2000;
omg=2*pi*f;
z0=dane_l0(3)+j*dane_l0(4)*omg*1.0e-3;
y0=j*dane_l0(5)*omg*1e-6;
gam0=sqrt(z0*y0);
zf0=sqrt(z0/y0);
a0=real(gam0);
b0=imag(gam0);
v0=omg/b0;		% predkosc fali
lb0=2*pi/b0;		% dlugosc fali


z1=dane_l1(3)+j*dane_l1(4)*omg*1.0e-3;
y1=j*dane_l1(5)*omg*1e-6;
gam1=sqrt(z1*y1);
zf1=sqrt(z1/y1);
a1=real(gam1);
b1=imag(gam1);
v1=omg/b1;		% predkosc fali
lb1=2*pi/b1;		% dlugosc fali

nk=100;
ll=300;
psi1=pi/2;
psi0=pi/2;
am0=1;
am1=1;
a=ll/nk;
for i=1:nk+1,
 x=(i-1)*a;
 a01(i)=exp(-a0*x);
 f01(i)=am0*a01(i)*sin(-b0*x+psi0);
 a11(i)=exp(-a1*x);
 f11(i)=am1*a11(i)*sin(-b1*x+psi1);
 t(i)=x;
end;


    plot(t,f01,t,a01,t,f11,t,a11);

    title('Fala pierwotna');
    grid;



