function Przyklad_zs_1
% Metoda zmiennych stanu: Dynamika modelu R1C1R2C2 przy wymuszeniu
% sinusoidalnym (harmonicznym)
clear all;
close all;
% Parametry obwodu:
R1 = 10;                % ohm
C1 = 47E-6;             % F = 47uF
R2 = 20;                % ohm
C2 = 1E-4;              % F = 100uF
T = 1E-4;               % s - krok modelowania
U = 100;                % V, amplituda napicia
f1 = 50;                % Hz, czstotliwo napicia
beta = 35;              % faza poczatkowa napiecia, stopnie

omg = 2*pi*f1;          % pulsacja napicia
beta = beta*pi/180;     % faza napicia, rad

% Parametry symulacji
tmax = 0.1;             % okres modelowania, s
x0 = [0 0];             % warunki pocztkowe
tspan = linspace(0,tmax,500);         % czasowe punkty rozwiazania
options = odeset('RelTol',1.0E-6);    % dokladnosc

% macierz stanu
A=[-(1/(R1*C1)+1/(R2*C1)) 1/(R2*C1);
   1/(R2*C2) -1/(R2*C2)];

[t x] = ode45(@f,tspan,x0,options); % rozwiazanie rownania

u = U*cos(omg*tspan+beta);      % napiecie tylko do prezentacji
plot(tspan,x(:,1),'-r',tspan,x(:,2),'--b',tspan,u,'-k');
legend('uC1','uC2','u','Location','NorthEast')
grid;

  % -----------------------------------------------------------------------
  % Funkcja prawej strony rownania rozniczkowego
  %
  function dxdt = f(t,x)
  % Pochodne funkcji
    u = U*cos(omg*t+beta);          % napiecie zasilajace
    dxdt = A * x + [u/(R1*C1); 0];
  end
end  
