% Przyklad_zs_2_1
clear all
close all

% parametry sieci 1
% R1=100;
% R2=10;
% L=0.1;
% C1=22E-6;
% C2=47E-6;

% parametry sieci 2
R1=2;
R2=10;
L=0.005;
C1=22E-4;
C2=47E-5;

% wejcia:
f=50;       % czstotliwo sygnau, Hz
U1 = 20;    % amplituda, V
U2 = 50;    % amplituda, V

% wartosci macierzy
A=[-R2/L 0;0 -1/(R1*(C1+C2))];
B=[-A(1,1) 0; 1/(C1+C2) -C2*A(2,2)/(C1+C2)];
C=[1 0;0 -C1*A(2,2);0 C2*A(2,2)];
D=[0 0;-C1*B(2,1) -C1*B(2,2); C2*B(2,1) C2*B(2,2)];
D1=[0 0;0 -C2*D(2,1);0 C1*D(3,1)];

% generacja systemu
sys=ss(A,B,C,D);
h=0.0001;   % krok symulacji

% wielkosci wejsciowe:
t=0:h:0.05;
u(1,:)=-U1*ones(size(t));
%u(2,:)=zeros(size(t));
u(2,:)=U2*sin(2*pi*f*t);

% uruchomienie systemu
%lsim(sys,u,t); grid;
[y,t1,x1]=lsim(sys,u,t);

figure(1);
% przebiegi sygnaw wejsciowych
plot(t1,u(1,:),'-k',t1,u(2,:),'-.k');    % state variables
legend('u1','u2','Location','SouthEast')
grid;

figure(2)
% przebiegi zmiennych stanu
plot(t1,x1(:,1),'-b',t1,x1(:,2),'-.b');    % state variables
legend('x1','x2','Location','NorthEast')
grid;

figure(3)
% pochodna
y1=[diff(u(1,:));diff(u(2,:))]/h;
y1=[y1 y1(:,end)];

% sygnaly wyjsciowe
y=D1*y1+y';
plot(t1,y(1,:),'-m',t1,y(2,:),'--r',t1,y(3,:),'-.m') % outputs
legend('y1','y2','y3','Location','NorthEast')
grid;



