% Model sieci RL z warystorem i zrodlem AC
% zerowe warunki poczatkowe
close all
clear all

% Parametry
R=10.0;
L=0.015;
Uamp=75;   % amplituda napicia
T=0.00002;
tmax=0.04;   % okres modelowania
kmax=round(tmax/T);
% Parametry modelu sieci
ki=0.001;   % parametry warystora
q=29;
Vref=48;
Var=q*ki/Vref;
GL=T/(2*L);
g11=1/R+GL;
g12=-GL;
g21=g12;
Gn1=0.1;  % poczatkowa przewodnosc warystora
Gnk(1)=Gn1;
g22=GL+Gn1;
eps=1.0e-5;

% warunki pocztkowe
ILk=0;  % zrodlo pradowe L
Iin=0;  % zrodlo zwiazane z iteracyjnym procesem
Ii(1)=Iin;
u2(1)=60;
i1(1)=Iin+Gn1*u2(1);
up=[1.0e3;-1.0e3];
% poczatkowy kat napiecia
fi=-pi/6;

% petla zmiany czasu
for k=1:kmax
    tk(k)=T*k;      % biezacy czas
    us(k)=Uamp*cos(100*pi*tk(k)+fi);
    jR(k)=us(k)/R;  % prad zrodlowy wymuszajacy
        
    if k>1      % z poprzedniego kroku czasowego
        u1(k)=u1(k-1);
        u2(k)=u2(k-1);
        i1(k)=i1(k-1);
    end
    % petla iteracyjna
    e_max=1.0e3;
    ll=0;
    while e_max>eps
      ll=ll+1;              % liczba iteracji
      Iin=i1(k)-Gn1*u2(k);
      G1=inv([g11 g12;g21 g22]);
      J=[jR(k)-ILk;ILk-Iin];
      U=G1*J;
      u1(k)=U(1);             % obliczone napiecia wezlowe
      u2(k)=U(2);
      % przygotowane zmienne do nastpnej iteracji
      i1(k)=ki*(u2(k)/Vref)^q;
      Gn1=Var*(u2(k)/Vref)^(q-1);
      g22=GL+Gn1;
      
      e_max=max(abs(up-U));
      up=U;
    end 
    % obliczanie historii dla nastepnego kroku
    ILk=i1(k)+(u1(k)-u2(k))*GL;
    Gnk(k)=Gn1;     % tylko do prezentacji na rysunkach
    Ii(k)=Iin;
    lit(k)=ll;
end
% prady w galeziach i przewodno
plot(tk,i1,'-r',tk,Gnk,'-b'); grid
legend('i1','Gn','Location','NorthEast')

% napiecia zrodlowe i w wezlach
figure(2)
plot(tk,us,'-r',tk,u1,'-b',tk,u2,'.-k'); grid
legend('us','u1','u2','Location','NorthEast')

% liczba iteracji
figure(3)
plot(tk,lit,'-b'); grid
