% Symulacja stanu przejsciowego w linii dlugiej z obciazeniem
% RoCo (polaczenie rownolegle) oraz impedancja zrodla RsLs

close all
clear all

% parametry obwodu:
% linia (na kilometr):
R=0.04; L=1.6E-3; C=1.05E-8; l=160;
% impedancja zrda
Rs=0.2;     % ohm
Ls=0.0127;  % H
% impedancja obciazenia
R0=278.0;  % ohm
C0=5.55E-6;% F
% es(t) = 180sin(100*pi*t+pi/3)kV
Am=180000;
fi=-pi/6;
T=4.0E-5;
t_koniec=0.1;
k_koniec=t_koniec/T;
%k_koniec=110;

v=1/sqrt(L*C);
m= round(l/(T*v));
a=2*pi/(0.02/T);
Zf=sqrt(L/C);
Rl=l*R;
Gf=1/(Zf+Rl/2);
hf=(2*Zf-Rl)/(2*Zf+Rl);
% obciazenie
G0=(2*C0*R0+T)/(R0*T);
G2=Gf+G0;
Gc=(2*C0*R0-T)/(R0*T);
j0k=0;  % j0(k-1) - wartosc poczatkowa
% impedancja zrodla
Gs=T/(2*Ls+Rs*T);
G1=Gf+Gs;
hs=(2*Ls-Rs*T)/(2*Ls+Rs*T);
jsk=0;
% rejestr przesuwny
j1=zeros(1,m);      % wartosci poczatkowe
j2=j1;
indx=1; % indeks do czytania/wpisywania

% petla czasu
for k=1:k_koniec
    Es(k)=Am*cos(a*k+fi);
    u1(k)=(Es(k)*Gs+jsk-j1(indx))/G1;
    u2(k)=(j0k-j2(indx))/G2;
    i1(k)=j1(indx)+Gf*u1(k);
    i2(k)=j2(indx)+Gf*u2(k);
    % historia obciazenia R0L0: j0k
    j0k=Gc*u2(k)-i2(k);
    jsk=hs*i1(k)+Gs*(Es(k)-u1(k));
    % zapisywanie do rejestrow
    j1(indx)=-Gf*u2(k)-hf*i2(k);
    j2(indx)=-Gf*u1(k)-hf*i1(k);
    
    zj1(k)=j1(indx);
    zj2(k)=j2(indx);
    % przesuniecie indeksu
    indx=indx+1;
    if indx>m
        indx=1;
    end
    % 
    t(k)=k*T;
       
end;

figure(1)
t1=t/(m*T);
plot(t1,u1,'-r',t1,100*i1,'-b',t1,u2,'-m',t1,100*i2,'-g');
set(gca,'YLim',[-3E5 4E5]);
set(gca,'XLim',[0 10]);
grid
legend('u1','i1','u2','i2','Location','NorthEast')

figure(2)
plot(t,u1,'-r',t,100*i1,'-b',t,u2,'-m',t,100*i2,'-g');
set(gca,'YLim',[-3E5 4E5]);
grid
legend('u1','i1','u2','i2','Location','NorthEast')

figure(3)
plot(t,zj1,'-r',t,zj2,'-b');
grid
legend('j1','j2','Location','SouthEast')
