% Symulacja stanu przejsciowego w linii dlugiej z obciazeniem
% RL.

close all
clear all

% parametry obwodu:
% linia (na kilometr):
R=0.04; L=1.6E-3; C=1.05E-8; l=160;
Rs=2.5;     % ohm
R0=225.0;   % ohm
L0=0.3469;  % H
% es(t) = 180sin(100*pi*t+pi/3)kV
Am=180000;
fi=-pi/6;
T=4.0E-5;
t_koniec=0.1;
k_koniec=t_koniec/T;
%k_koniec=110;

v=1/sqrt(L*C);
m= round(l/(T*v));
a=2*pi/(0.02/T);
Zf=sqrt(L/C);
Rl=l*R;
Gf=1/(Zf+Rl/2);
hf=(2*Zf-Rl)/(2*Zf+Rl);
G1=Gf+1/Rs;
G0=T/(2*L0+R0*T);
G2=Gf+G0;
h0=(2*L0-R0*T)/(2*L0+R0*T);
j0k=0;  % j0(k-1) - wartosc poczatkowa
% rejestr przesuwny
j1=zeros(1,m);      % wartosci poczatkowe
j2=j1;
indx=1; % indeks do czytania/wpisywania

% petla czasu
for k=1:k_koniec
    Es(k)=Am*cos(a*k+fi);
    u1(k)=(Es(k)/Rs-j1(indx))/G1;
    u2(k)=(j0k-j2(indx))/G2;
    i1(k)=j1(indx)+Gf*u1(k);
    i2(k)=j2(indx)+Gf*u2(k);
    % historia obciazenia R0L0: j0k
    j0k=h0*i2(k)-G0*u2(k);
    % zapisywanie do rejestrow
    j1(indx)=-Gf*u2(k)-hf*i2(k);
    j2(indx)=-Gf*u1(k)-hf*i1(k);
    
    zj1(k)=j1(indx);
    zj2(k)=j2(indx);
    % przesuniecie indeksu
    indx=indx+1;
    if indx>m
        indx=1;
    end
    % 
    t(k)=k*T;
       
end;

figure(1)
t1=t/(m*T);
plot(t1,u1,'-r',t1,100*i1,'-b',t1,u2,'-m',t1,100*i2,'-g');
set(gca,'YLim',[-3E5 4E5]);
set(gca,'XLim',[0 10]);
grid
legend('u1','i1','u2','i2','Location','SouthEast')

figure(2)
t=t/(m*T);
plot(t,u1,'-r',t,100*i1,'-b',t,u2,'-m',t,100*i2,'-g');
set(gca,'YLim',[-3E5 4E5]);
grid
legend('u1','i1','u2','i2','Location','NorthEast')

figure(3)
plot(t,zj1,'-r',t,zj2,'-b');
grid
legend('j1','j2','Location','SouthEast')
