% Symulacja stanu przejsciowego w linii dlugiej z obciazeniem
% rezystancyjnym.

close all
clear all

% parametry obwodu:
% linia (na kilometr):
R=0.04; L=1.6E-3; C=1.05E-8; l=160;
Rs=2.5; R0=250.0;
%R0=10;
% es(t) = 180sin(100*pi*t+pi/3)kV
Am=180000;
fi=-pi/6;
T=4.0E-5;
%T=64.0E-5;
t_koniec=0.025;
k_koniec=t_koniec/T;
%k_koniec=110;

% obliczenie parametrow modelu
v=1/sqrt(L*C);
m= round(l/(T*v));
a=2*pi/(0.02/T);
Zf=sqrt(L/C);
Rl=l*R;
Gf=1/(Zf+Rl/2);
hf=(2*Zf-Rl)/(2*Zf+Rl);
G1=Gf+1/Rs;
G2=Gf+1/R0;
% rejestr przesuwny
j1=zeros(1,m);  % zerowe warunki poczatkowe
j2=j1;
indx=1; % indeks do czytania/wpisywania do rejestrow

% petla czasu
for k=1:k_koniec
    Es(k)=Am*cos(a*k+fi);
    u1(k)=(Es(k)/Rs-j1(indx))/G1;
    u2(k)=-j2(indx)/G2;
    i1(k)=j1(indx)+Gf*u1(k);
    i2(k)=j2(indx)+Gf*u2(k);
    % zapisywanie do rejestrow
    j1(indx)=-Gf*u2(k)-hf*i2(k);
    j2(indx)=-Gf*u1(k)-hf*i1(k);
    
    zj1(k)=j1(indx);
    zj2(k)=j2(indx);
    % przesuniecie indeksu
    indx=indx+1;
    if indx>m
        indx=1;
    end
    % 
    t(k)=k*T;
       
end;

figure(1)
t1=t/(m*T);
plot(t1,u1,'-r',t1,100*i1,'-b',t1,u2,'-.r',t1,100*i2,'-.b');
grid
set(gca,'XLim',[0 10]);
legend('u1','i1','u2','i2','Location','NorthEast')

figure(2)
plot(t,u1,'-r',t,100*i1,'-b',t,u2,'-.r',t,100*i2,'-.b');
grid
legend('u1','i1','u2','i2','Location','SouthEast')

figure(3)
plot(t,zj1,'-r',t,zj2,'-b');
legend('j1','j2','Location','NorthEast')

grid
