function tarcie_b

% symulacja ukladu z Przykladu 4.2

clear all;
close all;

% Rozwiazywanie rowniania tarcia lepkiego

% -------
t_fin=20;           % okres symulacji, s
x0 = [0.5; 1.0];    % warunki pocztkowe
mi0=0.5;            % wspolczynnik tarcia
mic=0.4;
alfa=0.25;          % nachylenie charakterystyki
alfa=0.1;
g=9.81;
K=4.2;              % stala sprezyny
D=0.10;             % opory ruchu
M=1.5;              % masa
v0=0.6;             % predkosc tasmy
Pf=0;               % sila zewnetrzna
Pn=M*g;             % sila docisku

mir=mi0-mic;
p4=alfa/mir;
p3=Pn/M;
p2=K/M;
p1=D/M;

% -------
tspan = [0; t_fin];             % okres symulacji
opts = odeset('RelTol',1e-5,'AbsTol',1e-5); % dokladnosc rozwiazania
[t,x] = ode45(@trc_b,tspan,x0,opts);
% rownanie jest zdefiniowane w procedurze: dxdt = trc_b(t,x)

figure;
% przebiegi w czasie
plot(t,x(:,1),'-b',t,x(:,2),'-r',t,v0-x(:,2)); 
grid
xlabel('czas t, s');
ylabel('x_1, x_2');
set(gca,'YLim',[-1 2.5]);

figure
plot(x(:,1),x(:,2)); 
grid
xlabel('przesuniecie, m');
ylabel('predkosc, m/s');

% ------------------------
function dxdt = trc_b(t,x)
  % Wartosci pochodnych
  vw=v0-x(2);
  mi=(mir*exp(-p4*abs(vw))+mic)*sign(vw);
  
  dxdt = [x(2); 
          -p1*x(2)-p2*x(1)+p3*mi]; 
end

end  % tarcie_b

