% Funkcja inicjujca

% Wywoywane funkcje: 	wewnetrzne

% Wywoanie z:          symulacja M_M_1_b.m (gwna procedura)

function uruchom(l_iter)

global Lambda               % intensywnosc zgoszen
global s_liczba_sym_zdarzen % srednia liczba symulowanych zdarze 
global rodz_n_zdarzenia     % rodzaj nastepnego zdarzenia 
global liczba_w_syst        % liczba zdarzen w systemie do biezacego czasu
global liczba_w_q           % liczba zdarzen w kolejce
global status_obslugi       % status obslugi
global czas_kolejki         % czas oczekiwania w kolejce
global obszar_obslugi       % czas pracy obslugi
global czas_b               % czas biezacy 
global czas_o_zdarzenia     % czas wystapienia ostatniego zdarzenia
global czas_n_zdarzenia     % czas nastepnego zdarzenia
global ogolny_czas          % czas trwania symulacji
global N_odrz               % liczba odrzuconych z kolejki
global L_odrzuc             % tabela liczby odrzuconych z kolejki
global sr_czas_sys          % redni czas jednostki w systemie

% dla kolejnych iteracji
for ni=1:l_iter,   
  N_iter(ni)=0;             % srednia liczba oczekujcych w iteracji
  czas_b=0.0; 				% zegar, czas biezacy

  status_obslugi=0; 		% stan obslugi
  liczba_w_q=0; 			% dugo kolejki
  czas_o_zdarzenia=0.0; 

  liczba_w_syst=0;          % pocztkowa liczba klientw w systemie
  ogolny_czas=0.0;          % pocztkowa warto czasu
  czas_kolejki=0.0;
  obszar_obslugi=0.0;
  N_odrz=0;
  t=[]; Nq=[]; T=[]; Tq=[];
  L_odrzuc=[]; sr_czas_sys=[];

  % Pseudolosowy czas zdarzenia: funkcja wykladnicza
  u = rand(1);
  czas_n_zdarzenia(1) = czas_b - log(u)/Lambda;
  czas_n_zdarzenia(2) = 1.0*exp(30);
   
  %
  k=0;
  % prowad symulacj gdy obsuono mniejsz liczb klientw ni zaoono
  while(liczba_w_syst < s_liczba_sym_zdarzen)
   k=k+1;
   zegar; 				% nastpne zdarzenie
  
   % zapisz dane statystyczne

   delta_czas = czas_b - czas_o_zdarzenia;
   czas_o_zdarzenia = czas_b;

   czas_kolejki = czas_kolejki + liczba_w_q * delta_czas;
   obszar_obslugi = obszar_obslugi + status_obslugi * delta_czas;
   % 
   if (rodz_n_zdarzenia==1)
      wejscie;			% wywoaj procedur wejcia (kolejki)
     elseif (rodz_n_zdarzenia==2)
      obsluga;			% wywoaj procedur obsugi (wyjscia)
   end  
  
   t(k)=czas_b;
   Nq(k)=liczba_w_q;
   T(k)=delta_czas;
   Tq(k)=czas_kolejki/czas_b;
   L_odrzuc(k)=N_odrz/czas_b;
   sr_czas_sys(k)=ogolny_czas/liczba_w_syst;
  
   N_iter(ni)=N_iter(ni) + Nq(k); 
  
  end  % while

  N_iter(ni)=N_iter(ni)/k;

end;    % ni=1:l_iter,

% raport graficzny
figure
subplot(2,1,1);
plot(t,Nq);
xlabel('Czas, godz')
ylabel('Liczba oczekujacych w kolejce')
grid
subplot(2,1,2)
plot(t,Tq);
xlabel('Czas, godz')
ylabel('Srednia dlugosc kolejki')
grid 

figure;
subplot(2,1,1);
plot(t,sr_czas_sys);
xlabel('Czas, godz')
ylabel('Sredni czas w systemie, godz.')
grid
subplot(2,1,2);
plot(t,L_odrzuc);
xlabel('Czas, godz')
ylabel('Intensywnosc odrzucania, 1/godz')
grid

% ----------------------------
% Funkcje

function zegar

global rodz_n_zdarzenia l_r_zdarzen czas_b czas_n_zdarzenia 

  min_czas_n_zdarzenia=1.0*exp(29);

  rodz_n_zdarzenia=0;

  % okrelenie nastpnego rodzaju zdarzenia

  for i=1:l_r_zdarzen

      if(czas_n_zdarzenia(i)<min_czas_n_zdarzenia)
         min_czas_n_zdarzenia = czas_n_zdarzenia(i);
         rodz_n_zdarzenia = i;
      end;

  end

  if(rodz_n_zdarzenia == 0)
     disp(['Lista zdarze pusta w czasie ',num2str(czas_b)]);
  end

  czas_b=min_czas_n_zdarzenia;
 
% ----------

function wejscie
% Funkcja generujca zdarzenie na wejciu

global Q_Granica  Lambda  Mu liczba_w_syst N_odrz ...
       liczba_w_q status_obslugi czas_b czas_z_wej...
       czas_n_zdarzenia 

  % Pseudolosowy czas zdarzenia: funkcja wykladnicza
  u = rand(1);
  czas_n_zdarzenia(1) = czas_b - log(u)/Lambda; % czas nastpnego wejcia
    
  % sprawd, czy obsuga jest zajta
  if(status_obslugi == 1) % obsuga jest zajta
  
     liczba_w_q = liczba_w_q + 1 ; % zwiksz liczb oczekujcych w kolejce
     
     if(liczba_w_q > Q_Granica)     % sprawdz przekroczenie ograniczenia
        N_odrz = N_odrz + 1;
        liczba_w_q = Q_Granica;     % ograniczenie
     end

     czas_z_wej(liczba_w_q) = czas_b;

   else                 % obsuga nie jest zajeta
    
     liczba_w_syst = liczba_w_syst + 1;
     status_obslugi = 1;

     % Pseudolosowy czas obslugi: funkcja wykladnicza
     u = rand(1);
     czas_n_zdarzenia(2) = czas_b - log(u)/Mu;  % czas nastepn. wyjscia
          
  end

% ----------

function obsluga
% Funkcja generujca zdarzenie na wyjciu

global Mu liczba_w_syst liczba_w_q status_obslugi ...
       czas_b czas_z_wej czas_n_zdarzenia ogolny_czas 

    if(liczba_w_q == 0) 
     % kolejka jest pusta wiec usun obsluge oraz dzialania na wyjsciu
          
        status_obslugi = 0;
        czas_n_zdarzenia(2) = 1.0*exp(30);

     else
     % kolejka nie jest pusta, wiec zmniejsz liczbe jednostek
          
       liczba_w_q = liczba_w_q - 1;

       delta = czas_b - czas_z_wej(1);
       ogolny_czas = ogolny_czas + delta;

       liczba_w_syst = liczba_w_syst + 1;
       
      % Pseudolosowy czas obslugi: funkcja wykladnicza
       u = rand(1);
       czas_n_zdarzenia(2) = czas_b - log(u)/Mu;
               
       % przesun rejestr czasu zdarzen na wejsciu
       for i = 1:liczba_w_q
          czas_z_wej(i)=czas_z_wej(i+1);
       end
    
    end         
 