% Model symulacyjny kolejki z jednym stanowiskiem obsugi (serwerem): M/M/1

% Na podstawie: McGraw Hill - Simulation Modeling and Analysis - 
% Averill M. Law - W. David Kelton, 2003

% Wywoywane funkcje: 	uruchom.m (glowna procedura)
% Czas przybycia i obsugi s definiowane w procedurach wejscie oraz obsluga

clear all
close all

global Q_Granica            % graniczna dugo kolejki       
global Lambda               % intensywnosc zgoszen (1/godz)
global Mu                   % intensywnosc obsugi (1/godz)
global s_liczba_sym_zdarzen % srednia liczba symulowanych zdarze 
global rodz_n_zdarzenia     % rodzaj nastepnego zdarzenia 
global liczba_w_syst        % liczba zdarzen w systemie do biezacego czasu
global l_r_zdarzen          % liczba rodzajow zdarzen 
global liczba_w_q           % liczba zdarzen w kolejce
global status_obslugi       % status obslugi
global czas_kolejki         % czas oczekiwania w kolejce
global obszar_obslugi       % czas pracy obslugi
global czas_b               % czas biezacy 
global czas_z_wej           % czas zdarzenia na wyjsciu
global czas_o_zdarzenia     % czas wystapienia ostatniego zdarzenia
global czas_n_zdarzenia     % czas nastepnego zdarzenia
global ogolny_czas          % czas trwania symulacji
global sr_czas_sys          % sredni czas jednostki w systemie

% parametry symulacji
Q_Granica=200;				% graniczna dugo kolejki
delT_in=1/4;                % czas miedzy zglosz. (godz)
delT_out=12/60;             % czas obslugi (godz)
s_liczba_sym_zdarzen=1000;	% liczba symulowanych zdarze

obszar_obslugi=0;   		% zerowanie licznika
l_r_zdarzen=2;				% liczba rodzajow zdarze:
                            % 1 - wejscie, 2 - obsluga, 0 - brak zdarzen
Lambda=1/delT_in;           % intensywnosc zgoszen (1/godz)
Mu=1/delT_out;              % intensywnosc obsugi (1/godz)

l_iter = 1;                 % liczba iteracji
uruchom(l_iter);       		% uruchomienie symulacji

% sporzd raport

disp(['Dane odnoszace sie do ostatniej iteracji:']); 
disp(['redni czas w systemie  : ',num2str(ogolny_czas/liczba_w_syst),' godz.']);
disp(['rednia dugo kolejki : ',num2str(czas_kolejki/czas_b)])
disp(['Wykorzystanie obsugi   : ',num2str(obszar_obslugi/czas_b)]);
disp(['Czas wykonania symulacji: ',num2str(czas_b)]);
disp([' ']);

  