% Symulacja stanu przejsciowego w linii dlugiej z obciazeniem
% rezystancyjnym.

close all
clear all

% parametry obwodu:
% linia (na kilometr):
R=0.04; L=1.6E-3; C=1.05E-8; l=160;
Rs=2.5; R0=250.0;
% es(t) = 180sin(100*pi*t+pi/3)kV
Am=180000;
fi=pi/3;
T=4.0E-5;
t_koniec=0.025;
k_koniec=t_koniec/T;
%k_koniec=110;

v=1/sqrt(L*C);
m= round(l/(T*v));
a=2*pi/(0.02/T);
Zf=sqrt(L/C);
Rl=l*R;
Gf=1/(Zf+Rl/2);
hf=(2*Zf-Rl)/(2*Zf+Rl);
G1=Gf+1/Rs;
G2=Gf+1/R0;
% rejestr przesuwny
j1=zeros(1,m);
j2=j1;
indx=1; % indeks do czytania/wpisywania

% petla czasu
for k=1:k_koniec
    Es(k)=Am*sin(a*k+fi);
    u1(k)=(Es(k)/Rs-j1(indx))/G1;
    u2(k)=-j2(indx)/G2;
    i1(k)=j1(indx)+Gf*u1(k);
    i2(k)=j2(indx)+Gf*u2(k);
    % zapisywanie do rejestrow
    j1(indx)=-Gf*u2(k)-hf*i2(k);
    j2(indx)=-Gf*u1(k)-hf*i1(k);
    
    zj1(k)=j1(indx);
    zj2(k)=j2(indx);
    % przesuniecie indeksu
    indx=indx+1;
    if indx>m
        indx=1;
    end
    % 
    t(k)=k*T;
       
end;

% u1, u2, i1, i2
figure(1)
%t=t/(m*T);
plot(t,u1,'-r',t,100*i1,'-b',t,u2,'-.r',t,100*i2,'-.b');
grid

% j1, j2
figure(2)
plot(t,zj1,'-r',t,zj2,'-b');
%xlabel('x'); ylabel('y')
grid
