% parametry do programu: naped_2_mass_2.slx
clear all;
close all;

%Parameters of simulation 
dt=0.0004;      % integration step
start=0;
t_simul=1;      % the duration of the simulation

Jr = 28;        % moment bezwladnosci silnika
Jm = 47.72;     % moment bezwladnosci obciazenia
sn = 0.0233;	% poslizg znamionowy silnika
kr1 = 120000;   % wspolczynnik sztywnosci ukladu
k12 = 72000;
k2m = 90000;
Tm0 = 720.0;    % wspczynnik modelu obciazenia
kM = 1.564;
Ten = 2013.5;   % znamionowy moment napedowy
Te0 = 802.98;   % poczatkowy moment napedowy
mir = 0.045;    % wspolczynnik tlumienia
mim = 0.05;
pM = 2.14;      % przeciazalnosc momentem
MTKr0 = 110;    % moment tarcia suchego kinetycznego
MTKm0 = 105;
gamr0 = 2*pi/180;     % luz katowy, rad
gamm0 = 1.0*pi/180;     % luz katowy, rad
gamma0 = 0;     % wartosc poczatkowa kata
MTSr0 = 82.0;   % moment tarcia suchego
MTSm0 = 102.0;
epsr_omg = 0.01; % granica ruchu silnika
epsm_omg = 0.01; % granica ruchu maszyny
omg1 = pi;      % synchroniczna predkosc katowa silnika
omega0 = 0;     % wartosc poczatkowa predkosci
%
sk = sn*(pM+sqrt(pM*pM-1));
Te_a1 = 2*pM*Ten;
Te_a2 = omg1*sk;
gam_rm0 = gamr0 - gamm0;
krm=1/(1/kr1+1/k12+1/k2m);
omg_obr = 1500/pi;  % skalowanie: rad/s -> obr/min
omg_stp = 0.1*50*180/pi;   % skalowanie: rad -> stopnie

%call simulink model
sim('naped_2_mass_2');
set_param('naped_2_mass_2','Solver','ode1','StopTime','t_simul');

% rysunki
t=gam_r.Time;
subplot(3,1,1);
plot(t,gam_r.Data,'-r',t,gam_m.Data,'-b',t,del_f.Data/10,'-m');
grid
subplot(3,1,2);
plot(t,omg_r.Data,'-r',t,omg_m.Data,'-b',t,pi*t./t,'--k');
grid
subplot(3,1,3);
plot(t,M_r.Data/1000,'-r',t,M_m.Data/1000,'-b');
grid;

