function [t,x]=tarcie_1

clear all;
close all;

% Rozwiazywanie rowniania tarcia
opts = odeset('RelTol',1e-5,'AbsTol',1e-5);
% -------
x0 = [0.5; 0.0];    % warunki pocztkowe
mi=0.02;            % wspolczynnik tarcia
k=1.2;              % stala sprezyny
m=1;                % masa
P=0;                % sila
g=9.81;             % przysp. ziemskie
Tg=mi*g*m;          % tarcie graniczne
Tk=0.95*Tg;         % tarcie kinetyczne
Pz=P-k*x0(1);
% -------
tspan = [0; 6];             % okres symulacji

[t,x] = ode45(@trc_1,tspan,x0,opts);

figure;
% przebiegi w czasie
plot(t,x(:,1),'-b',t,x(:,2),'-r'); grid
xlabel('czas t, s');
ylabel('x_1, x_2');
set(gca,'YLim',[-0.4 0.5]);

% ------------------------
function dxdt = trc_1(t,x)
  % Wartosci pochodnych
  Pz=P-k*x(1);
  if abs(x(2))>0,
       a=Pz-Tk*sign(x(2));
   else,
       a=Pz-Tg*prz_1(Pz/Tg);
  end;
  dxdt = [x(2); a/m]; 
end

% ------------------------
function war = prz_1(z)
  % Wartosci pochodnych
  if abs(z)<1,
       war=z;
   else,
       war=sign(z);
  end;
end

end  % tarcie_1

