% Rozwiazywanie rownan z przykladu 3.2 oraz tworzenie portretu fazowego
% dla wielu warunkow poczatkowych

close all
% parametry modelu
czas = [0, 8];
g1=2;
g2=2;
% rozwiazywanie rownan stanu
options = odeset('RelTol',1e-10,'AbsTol',[1e-12 1e-12]);
ode = @(t,y) P_3_2a(t,y,g1,g2);

y0=[-3 1;-2.4 1;-2.3 1;-2 1;-1.5 1;0 1;025 1;0.5 1;0.5 0.5; 0.5 0;0.5 -1];
y0=[y0;0.25 -1;0 -1;-1.65 -1;-0.5 -1;-1 -1;-1.5 -1;-2 -1;-3 -0.5;-3 0;-3 0.5];
k=size(y0,1);
figure
for m=1:k,
[t,y] = ode45(ode, czas, y0(m,:), options);

% portret fazowy
hold on
plot(y(:,1),y(:,2),'-b');
end;
set(gca,'XLim',[-3 0.5],'YLim',[-1 1])
title('Portret fazowy x-y');
xlabel('x'); ylabel('y')
grid
