% Rozwiazywanie rownan z przykladu 3.2 oraz tworzenie portretu fazowego
% dla wielu warunkow poczatkowych wokol punktu (-2 0) ktory zostal
% przesuniety do poczatku ukladu wspolrzednych

close all
% parametry modelu
czas = [0, 8];
g1=-2;
g2=2;
% rozwiazywanie rownan stanu
options = odeset('RelTol',1e-10,'AbsTol',[1e-12 1e-12]);
ode = @(t,y) P_3_2a(t,y,g1,g2);

y0=[-1 1;-0.8 1;-0.6 1;-0.4 1;0 1;-0.2 1;0.25 1;0.5 1;0.65 1; 1 -0.2;1 -1];
y0=[y0;0.8 -1;0.6 -1;0.4 -1;0.2 -1;0 -1 ;-1 -1;-0.5 -1;-1 -0.5;-1 0;-1 0.5];
k=size(y0,1);
figure
for m=1:k,
[t,y] = ode45(ode, czas, y0(m,:), options);

% portret fazowy
hold on
plot(y(:,1),y(:,2),'-b');
end;
set(gca,'XLim',[-1 1],'YLim',[-1 1])
title('Portret fazowy x-y');
xlabel('x'); ylabel('y')
grid
