% Rozwiazywanie rownan z przykladu 3.2 oraz tworzenie portretu fazowego
% Do rozwiazania rownan stanu zastosowano metode ode45.
% Przedzial czasu: [0 10] s, warunki poczatkowe: [-1.5;-1].
% Rownanie jest zdefiniowane w pliku P_3_2a.m

close all
% parametry modelu
czas = [0, 10];
y0=[-1.5 -1];
g1=2;
g2=2;
% rozwiazywanie rownan stanu
options = odeset('RelTol',1e-10,'AbsTol',[1e-12 1e-12]);
ode = @(t,y) P_3_2a(t,y,g1,g2);
[t,y] = ode45(ode, czas, y0, options);

figure(1)
plot(t,y(:,1),'-.r',t,y(:,2),'-b');
title('Przebiegi zmiennych stanu');
set(gca,'XLim',[0 10])
xlabel('t'); ylabel('y')
legend(gca,'x','y');
grid


% portret fazowy
figure(2)
plot(y(:,1),y(:,2),'-b');
%set(gca,'XLim',[-3 0.5],'YLim',[-1 1])
title('Portret fazowy x-y');
xlabel('x'); ylabel('y')
grid
