% Rownania Lorenza
% Do rozwiazania ukladu rownan Lorenza zastosowano metode ode45.
% Przedzial czasu: [0 okres] s, warunki poczatkowe: [0 1 5].
% Rownania i parametry sa zdefiniowane w pliku lorenz_0.m

close all

options = odeset('RelTol',1e-4,'AbsTol',[1e-4 1e-4 1e-5]);
okres=20;   % przedzial czasu modelowania
[T,Y] = ode45(@lorenz_0,[0 okres],[0 1 5],options);
% Wykres we wspolrzednych y1, y2, y3
plot3(Y(:,1),Y(:,2),Y(:,3)); 
xlabel('Y1');
ylabel('Y2');
zlabel('Y3');
grid;
figure
plot(Y(:,1),Y(:,3)); grid;
% wykres przebiegow czasowych
figure
plot(T,Y(:,1),'-g',T,Y(:,2),'-m',T,Y(:,3),'-');
grid;

